<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        // 1) Create table and columns first (no FK yet)
        Schema::create('stock_trackings', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->id(); // bigint unsigned AI

            // FK column (same type as parent)
            $table->unsignedBigInteger('goods_requisition_detail_id');

            // Other columns (as per your dump)
            $table->string('type', 191);
            $table->unsignedBigInteger('tracking_id')->default(0);
            $table->integer('quantity');      // int(11)
            $table->double('price');          // double
            $table->timestamps();             // created_at, updated_at (nullable)

            // Helpful index (matches phpMyAdmin view)
            $table->index('goods_requisition_detail_id', 'stock_trackings_grd_id_index');
        });

        // 2) Add the foreign key separately to avoid errno 150 if parent isn't ready yet
        Schema::table('stock_trackings', function (Blueprint $table) {
            if (Schema::hasTable('goods_requisition_details')) {
                $table->foreign(
                        'goods_requisition_detail_id',
                        'stock_trackings_goods_requisition_detail_id_foreign'
                    )
                    ->references('id')
                    ->on('goods_requisition_details')
                    ->cascadeOnUpdate()
                    ->restrictOnDelete();
            }
        });
    }

    public function down(): void
    {
        // Drop FK if it exists, then drop table
        Schema::table('stock_trackings', function (Blueprint $table) {
            try { $table->dropForeign('stock_trackings_goods_requisition_detail_id_foreign'); } catch (\Throwable $e) { /* ignore */ }
        });

        Schema::dropIfExists('stock_trackings');
    }
};

