<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('core4_soft_payment_schedules', function (Blueprint $table) {
            $table->id();
            $table->double('amount');
            $table->string('date', 191);
            $table->string('alert_date', 191);
            $table->boolean('is_paid')->default(0);
            $table->timestamp('paid_at')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('core4_soft_payment_schedules');
    }
};
