<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_units', function (Blueprint $t) {
            $t->engine = 'InnoDB';

            $t->id();                                        // BIGINT UNSIGNED AI
            $t->string('name', 191);                         // NOT NULL
            $t->decimal('conversation_size', 10, 2)->nullable();
            $t->string('status', 191)->default('0');         // matches dump's varchar default '0'

            // keep FK columns with the same nullability as the dump
            $t->unsignedBigInteger('created_by');            // NOT NULL
            $t->unsignedBigInteger('updated_by')->nullable();// NULL

            // timestamps are NULL-able in the dump
            $t->timestamp('created_at')->nullable();
            $t->timestamp('updated_at')->nullable();
        });

        // Add FKs only if `users` exists (prevents errno:150 on fresh setups)
        Schema::table('rm_units', function (Blueprint $t) {
            if (Schema::hasTable('users')) {
                $t->foreign('created_by', 'rm_units_created_by_foreign')
                  ->references('id')->on('users')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();

                $t->foreign('updated_by', 'rm_units_updated_by_foreign')
                  ->references('id')->on('users')
                  ->cascadeOnUpdate()
                  ->nullOnDelete();
            }
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_units');
    }
};

