<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_supplier_payments', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->id();                                      // BIGINT UNSIGNED AI
            $table->unsignedBigInteger('supplier_id')->nullable(); // -> rm_suppliers.id (nullable in dump)
            $table->tinyInteger('payment_type')->nullable();
            $table->string('invoice_no', 191)->nullable();
            $table->date('date')->nullable();

            $table->double('sup_current_balance')->nullable();
            $table->double('sup_paid_amount')->nullable();
            $table->double('discount')->nullable();

            $table->tinyInteger('status')->default(1);         // NOT NULL default 1
            $table->text('remark')->nullable();

            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->timestamps();
        });

        // Add foreign keys ONLY if the parent tables exist (prevents errno:150)
        Schema::table('rm_supplier_payments', function (Blueprint $table) {
            // supplier_id -> rm_suppliers (or suppliers fallback)
            if (Schema::hasTable('rm_suppliers')) {
                $table->foreign('supplier_id', 'rm_supplier_payments_supplier_id_foreign')
                      ->references('id')->on('rm_suppliers')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();
            } elseif (Schema::hasTable('suppliers')) {
                $table->foreign('supplier_id', 'rm_supplier_payments_supplier_id_foreign')
                      ->references('id')->on('suppliers')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();
            }

            // created_by / updated_by -> users (optional)
            if (Schema::hasTable('users')) {
                $table->foreign('created_by', 'rm_supplier_payments_created_by_foreign')
                      ->references('id')->on('users')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();

                $table->foreign('updated_by', 'rm_supplier_payments_updated_by_foreign')
                      ->references('id')->on('users')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();
            }
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_supplier_payments');
    }
};

