<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_suppliers', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->bigIncrements('id');

            $table->string('name', 191)->nullable();

            // ✅ supplierid (lowercase, NOT NULL + UNIQUE)
            $table->string('supplierid', 191);
            $table->unique('supplierid', 'supplierid');

            $table->unsignedBigInteger('account_id')->nullable();
            $table->string('company_name', 191)->nullable();

            $table->string('personal_phone', 191);      // NOT NULL
            $table->integer('bussiness_phone')->nullable();

            $table->unsignedBigInteger('supplier_type')->nullable(); // plain column
            $table->string('email', 191)->nullable();
            $table->string('address', 191)->nullable();

            $table->decimal('opening_balance', 10, 2)->nullable();
            $table->decimal('current_balance', 16, 2)->default(0.00);
            $table->decimal('due_limit', 10, 2)->nullable();
            $table->string('remarks', 191)->nullable();

            $table->tinyInteger('discount_type')->nullable();
            $table->decimal('discount', 10, 2)->nullable();
            $table->decimal('assume_rate', 10, 2)->nullable();

            $table->text('image')->nullable();
            $table->tinyInteger('status')->default(0);

            $table->unsignedBigInteger('created_by');       // NOT NULL
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->unsignedBigInteger('party_type_id')->nullable();
            $table->unsignedBigInteger('bag_warehouse_id'); // NOT NULL
            $table->integer('bag_opening');                 // NOT NULL

            $table->timestamps();
            $table->softDeletes(); // ✅ deleted_at

            // indexes (same names)
            $table->index('created_by', 'rm_suppliers_created_by_index');
            $table->index('updated_by', 'rm_suppliers_updated_by_index');

            // FKs (optional; keep same behavior)
            if (Schema::hasTable('accounts')) {
                $table->foreign('account_id', 'rm_suppliers_account_id_foreign')
                      ->references('id')->on('accounts')
                      ->cascadeOnUpdate()->nullOnDelete();
            }

            if (Schema::hasTable('party_types')) {
                $table->foreign('party_type_id', 'rm_suppliers_party_type_id_foreign')
                      ->references('id')->on('party_types')
                      ->cascadeOnUpdate()->nullOnDelete();
            }

            if (Schema::hasTable('warehouses')) {
                $table->foreign('bag_warehouse_id', 'rm_suppliers_bag_warehouse_id_foreign')
                      ->references('id')->on('warehouses')
                      ->cascadeOnUpdate()->restrictOnDelete();
            }

            if (Schema::hasTable('users')) {
                $table->foreign('created_by', 'rm_suppliers_created_by_foreign')
                      ->references('id')->on('users')
                      ->cascadeOnUpdate()->restrictOnDelete();

                $table->foreign('updated_by', 'rm_suppliers_updated_by_foreign')
                      ->references('id')->on('users')
                      ->cascadeOnUpdate()->nullOnDelete();
            }
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_suppliers');
    }
};


