<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_sale_return_details', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->id();

            // FK columns from your dump (nullable)
            $table->unsignedBigInteger('sale_return_id')->nullable()->index();
            $table->unsignedBigInteger('sale_detail_id')->nullable()->index();
            $table->unsignedBigInteger('product_id')->nullable()->index();
            $table->unsignedBigInteger('warehouse_id')->nullable();

            // Data columns
            $table->decimal('kg', 8, 2)->nullable();
            $table->decimal('bag', 8, 2)->nullable();
            $table->decimal('mon', 8, 2)->nullable();
            $table->decimal('price', 8, 2)->nullable();
            $table->decimal('total_amount', 8, 2)->nullable();
            $table->string('product_condition', 191)->nullable();

            $table->timestamps();
        });

        // Add foreign keys only if parent tables exist
        Schema::table('rm_sale_return_details', function (Blueprint $table) {
            // sale_return_id -> rm_sale_returns
            if (Schema::hasTable('rm_sale_returns')) {
                $table->foreign('sale_return_id', 'rm_sale_return_details_sale_return_id_foreign')
                      ->references('id')->on('rm_sale_returns')
                      ->cascadeOnUpdate()->nullOnDelete();
            }

            // sale_detail_id -> rm_sale_details (or fallback to sale_details)
            if (Schema::hasTable('rm_sale_details')) {
                $table->foreign('sale_detail_id', 'rm_sale_return_details_sale_detail_id_foreign')
                      ->references('id')->on('rm_sale_details')
                      ->cascadeOnUpdate()->nullOnDelete();
            } elseif (Schema::hasTable('sale_details')) {
                $table->foreign('sale_detail_id', 'rm_sale_return_details_sale_detail_id_foreign')
                      ->references('id')->on('sale_details')
                      ->cascadeOnUpdate()->nullOnDelete();
            }

            // product_id -> rm_products (or fallback to products)
            if (Schema::hasTable('rm_products')) {
                $table->foreign('product_id', 'rm_sale_return_details_product_id_foreign')
                      ->references('id')->on('rm_products')
                      ->cascadeOnUpdate()->nullOnDelete();
            } elseif (Schema::hasTable('products')) {
                $table->foreign('product_id', 'rm_sale_return_details_product_id_foreign')
                      ->references('id')->on('products')
                      ->cascadeOnUpdate()->nullOnDelete();
            }

            // warehouse_id -> warehouses (optional)
            if (Schema::hasTable('warehouses')) {
                $table->foreign('warehouse_id', 'rm_sale_return_details_warehouse_id_foreign')
                      ->references('id')->on('warehouses')
                      ->cascadeOnUpdate()->nullOnDelete();
            }
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_sale_return_details');
    }
};
