<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_sale_returns', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->id();

            // Columns per your dump
            $table->string('invoice_no', 191)->nullable();

            $table->unsignedBigInteger('sale_id')->nullable()->index('rm_sale_returns_sale_id_index');
            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('customer_id')->nullable();
            $table->unsignedBigInteger('warehouse_id')->nullable();

            $table->date('return_date')->nullable();
            $table->string('return_reason', 191)->nullable();
            $table->string('note', 191)->nullable();

            // Your dump shows varchar with default '0'
            $table->string('is_approved', 191)->default('0');

            $table->decimal('total_return_bag',    15, 2)->nullable();
            $table->decimal('total_return_kg',     15, 2)->nullable();
            $table->decimal('total_return_mon',    15, 2)->nullable();
            $table->decimal('total_return_amount', 15, 2)->nullable();

            $table->decimal('paid_amount', 8, 2)->default(0.00);
            $table->decimal('due_amount',  8, 2)->default(0.00);

            $table->unsignedBigInteger('payment_type')->nullable();
            $table->unsignedBigInteger('return_by')->nullable();
            $table->unsignedBigInteger('approved_by')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->timestamps();

            $table->decimal('sale_return_cost', 16, 2)->nullable();
        });

        // Add FKs only if parent tables exist (prevents errno:150)
        Schema::table('rm_sale_returns', function (Blueprint $table) {
            // sale_id -> rm_sales / sales
            if (Schema::hasTable('rm_sales')) {
                $table->foreign('sale_id', 'rm_sale_returns_sale_id_foreign')
                      ->references('id')->on('rm_sales')
                      ->cascadeOnUpdate()->nullOnDelete();
            } elseif (Schema::hasTable('sales')) {
                $table->foreign('sale_id', 'rm_sale_returns_sale_id_foreign')
                      ->references('id')->on('sales')
                      ->cascadeOnUpdate()->nullOnDelete();
            }

            // company_id -> companies
            if (Schema::hasTable('companies')) {
                $table->foreign('company_id', 'rm_sale_returns_company_id_foreign')
                      ->references('id')->on('companies')
                      ->cascadeOnUpdate()->nullOnDelete();
            }

            // customer_id -> rm_customers / customers
            if (Schema::hasTable('rm_customers')) {
                $table->foreign('customer_id', 'rm_sale_returns_customer_id_foreign')
                      ->references('id')->on('rm_customers')
                      ->cascadeOnUpdate()->nullOnDelete();
            } elseif (Schema::hasTable('customers')) {
                $table->foreign('customer_id', 'rm_sale_returns_customer_id_foreign')
                      ->references('id')->on('customers')
                      ->cascadeOnUpdate()->nullOnDelete();
            }

            // warehouse_id -> warehouses
            if (Schema::hasTable('warehouses')) {
                $table->foreign('warehouse_id', 'rm_sale_returns_warehouse_id_foreign')
                      ->references('id')->on('warehouses')
                      ->cascadeOnUpdate()->nullOnDelete();
            }

            // payment_type -> payment_types / payment_methods (if you have either)
            if (Schema::hasTable('payment_types')) {
                $table->foreign('payment_type', 'rm_sale_returns_payment_type_foreign')
                      ->references('id')->on('payment_types')
                      ->cascadeOnUpdate()->nullOnDelete();
            } elseif (Schema::hasTable('payment_methods')) {
                $table->foreign('payment_type', 'rm_sale_returns_payment_type_foreign')
                      ->references('id')->on('payment_methods')
                      ->cascadeOnUpdate()->nullOnDelete();
            }

            // user references (created_by, updated_by, return_by, approved_by) → users
            if (Schema::hasTable('users')) {
                $table->foreign('created_by', 'rm_sale_returns_created_by_foreign')
                      ->references('id')->on('users')->cascadeOnUpdate()->nullOnDelete();

                $table->foreign('updated_by', 'rm_sale_returns_updated_by_foreign')
                      ->references('id')->on('users')->cascadeOnUpdate()->nullOnDelete();

                $table->foreign('return_by', 'rm_sale_returns_return_by_foreign')
                      ->references('id')->on('users')->cascadeOnUpdate()->nullOnDelete();

                $table->foreign('approved_by', 'rm_sale_returns_approved_by_foreign')
                      ->references('id')->on('users')->cascadeOnUpdate()->nullOnDelete();
            }
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_sale_returns');
    }
};

