<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_sale_details', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->id();

            // ==== Columns (exactly like your dump) ====
            $table->unsignedBigInteger('sale_id')->nullable()->index('rm_sale_details_sale_id_index');
            $table->unsignedBigInteger('product_id')->nullable()->index('rm_sale_details_product_id_index');
            $table->unsignedBigInteger('bag_type_id')->nullable()->index('rm_sale_details_bag_type_id_index');

            $table->decimal('price',        10, 2)->default(0.00);
            $table->decimal('total_price',  10, 2)->default(0.00);

            $table->decimal('kg',           10, 2)->default(0.00);
            $table->decimal('bag',          10, 2)->default(0.00);
            $table->decimal('mon',          10, 2)->default(0.00);

            $table->decimal('returned_kg',   8, 2)->default(0.00);
            $table->decimal('returned_bag',  8, 2)->default(0.00);
            $table->decimal('returned_mon',  8, 2)->default(0.00);

            $table->decimal('delivery_kg',  20, 2)->default(0.00);
            $table->decimal('delivery_bag', 20, 2)->default(0.00);
            $table->decimal('delivery_mon', 20, 2)->default(0.00);

            $table->timestamps();

            $table->string('remarks', 191)->nullable();

            $table->decimal('damage_kg',   8, 2)->default(0.00);
            $table->decimal('damage_bag',  8, 2)->default(0.00);
            $table->decimal('damage_mon',  8, 2)->default(0.00);

            $table->unsignedBigInteger('warehouse_id')->nullable()->index('rm_sale_details_warehouse_id_index');
        });

        // ====== Add foreign keys only if parent tables exist ======
        Schema::table('rm_sale_details', function (Blueprint $table) {
            // sale_id -> rm_sales.id (fallback: sales)
            if (Schema::hasTable('rm_sales')) {
                $table->foreign('sale_id', 'rm_sale_details_sale_id_foreign')
                      ->references('id')->on('rm_sales')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();
            } elseif (Schema::hasTable('sales')) {
                $table->foreign('sale_id', 'rm_sale_details_sale_id_foreign')
                      ->references('id')->on('sales')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();
            }

            // product_id -> rm_products.id (fallback: products)
            if (Schema::hasTable('rm_products')) {
                $table->foreign('product_id', 'rm_sale_details_product_id_foreign')
                      ->references('id')->on('rm_products')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();
            } elseif (Schema::hasTable('products')) {
                $table->foreign('product_id', 'rm_sale_details_product_id_foreign')
                      ->references('id')->on('products')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();
            }

            // bag_type_id -> bag_types.id (fallback: rm_bag_types)
            if (Schema::hasTable('bag_types')) {
                $table->foreign('bag_type_id', 'rm_sale_details_bag_type_id_foreign')
                      ->references('id')->on('bag_types')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();
            } elseif (Schema::hasTable('rm_bag_types')) {
                $table->foreign('bag_type_id', 'rm_sale_details_bag_type_id_foreign')
                      ->references('id')->on('rm_bag_types')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();
            }

            // warehouse_id -> warehouses.id
            if (Schema::hasTable('warehouses')) {
                $table->foreign('warehouse_id', 'rm_sale_details_warehouse_id_foreign')
                      ->references('id')->on('warehouses')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();
            }
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_sale_details');
    }
};
