<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_purchase_return_details', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->id();

            // Columns from your structure
            $table->unsignedBigInteger('purchase_return_id')->nullable()->index('rm_prd_purchase_return_id_index');
            $table->unsignedBigInteger('purchase_detail_id')->nullable()->index('rm_prd_purchase_detail_id_index');
            $table->unsignedBigInteger('product_id')->nullable()->index('rm_prd_product_id_index');
            $table->unsignedBigInteger('warehouse_id')->nullable()->index('rm_prd_warehouse_id_index');

            $table->decimal('kg',   8, 2)->nullable();
            $table->decimal('bag',  8, 2)->nullable();
            $table->decimal('mon',  8, 2)->nullable();
            $table->decimal('price',        8, 2)->nullable();
            $table->decimal('total_amount', 8, 2)->nullable();

            $table->string('product_condition', 191)->nullable();

            $table->timestamps();
        });

        // Add foreign keys only if parent tables exist (prevents errno:150)
        Schema::table('rm_purchase_return_details', function (Blueprint $table) {
            if (Schema::hasTable('rm_purchase_returns')) {
                $table->foreign('purchase_return_id', 'rm_purchase_return_details_purchase_return_id_foreign')
                      ->references('id')->on('rm_purchase_returns')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();
            }

            if (Schema::hasTable('rm_purchase_details')) {
                $table->foreign('purchase_detail_id', 'rm_purchase_return_details_purchase_detail_id_foreign')
                      ->references('id')->on('rm_purchase_details')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();
            }

            // In RM module, products usually live in `rm_products`
            // Change to `products` if your setup uses that instead.
            if (Schema::hasTable('rm_products')) {
                $table->foreign('product_id', 'rm_purchase_return_details_product_id_foreign')
                      ->references('id')->on('rm_products')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();
            } elseif (Schema::hasTable('products')) {
                $table->foreign('product_id', 'rm_purchase_return_details_product_id_foreign')
                      ->references('id')->on('products')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();
            }

            if (Schema::hasTable('warehouses')) {
                $table->foreign('warehouse_id', 'rm_purchase_return_details_warehouse_id_foreign')
                      ->references('id')->on('warehouses')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();
            }
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_purchase_return_details');
    }
};
