<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_purchase_returns', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->id();

            // From your dump
            $table->string('invoice_no', 191)->nullable();

            $table->unsignedBigInteger('purchase_id')->nullable()->index('rm_purchase_returns_purchase_id_index');
            $table->unsignedBigInteger('company_id')->nullable()->index('rm_purchase_returns_company_id_index');
            $table->unsignedBigInteger('supplier_id')->nullable()->index('rm_purchase_returns_supplier_id_index');
            $table->unsignedBigInteger('warehouse_id')->nullable()->index('rm_purchase_returns_warehouse_id_index');

            $table->date('return_date')->nullable();
            $table->string('return_reason', 191)->nullable();
            $table->string('note', 191)->nullable();

            $table->tinyInteger('purchase_type')->nullable()->comment('1=>raw,2=>finish');
            $table->string('is_approved', 191)->default('0'); // matches dump (varchar)

            $table->decimal('total_return_bag', 15, 2)->nullable();
            $table->decimal('total_return_kg',  15, 2)->nullable();
            $table->decimal('total_return_mon', 15, 2)->nullable();
            $table->decimal('total_return_amount', 15, 2)->nullable();

            $table->decimal('paid_amount', 8, 2)->default(0.00);
            $table->decimal('due_amount',  8, 2)->default(0.00);

            $table->unsignedBigInteger('payment_type')->nullable()->index('rm_purchase_returns_payment_type_index');

            $table->unsignedBigInteger('return_by')->nullable()->index('rm_purchase_returns_return_by_index');
            $table->unsignedBigInteger('approved_by')->nullable()->index('rm_purchase_returns_approved_by_index');

            $table->unsignedBigInteger('created_by')->nullable()->index('rm_purchase_returns_created_by_index');
            $table->unsignedBigInteger('updated_by')->nullable()->index('rm_purchase_returns_updated_by_index');

            $table->timestamps();
        });

        // Attach FKs only when the referenced tables exist
        Schema::table('rm_purchase_returns', function (Blueprint $table) {
            // purchase_id -> rm_purchases(id)
            if (Schema::hasTable('rm_purchases')) {
                $table->foreign('purchase_id', 'rm_purchase_returns_purchase_id_foreign')
                    ->references('id')->on('rm_purchases')
                    ->cascadeOnUpdate()
                    ->nullOnDelete();
            }

            // company_id -> companies(id)
            if (Schema::hasTable('companies')) {
                $table->foreign('company_id', 'rm_purchase_returns_company_id_foreign')
                    ->references('id')->on('companies')
                    ->cascadeOnUpdate()
                    ->nullOnDelete();
            }

            // supplier_id -> suppliers(id)
            if (Schema::hasTable('suppliers')) {
                $table->foreign('supplier_id', 'rm_purchase_returns_supplier_id_foreign')
                    ->references('id')->on('suppliers')
                    ->cascadeOnUpdate()
                    ->nullOnDelete();
            }

            // warehouse_id -> warehouses(id)
            if (Schema::hasTable('warehouses')) {
                $table->foreign('warehouse_id', 'rm_purchase_returns_warehouse_id_foreign')
                    ->references('id')->on('warehouses')
                    ->cascadeOnUpdate()
                    ->nullOnDelete();
            }

            // payment_type -> payment_types(id)
            if (Schema::hasTable('payment_types')) {
                $table->foreign('payment_type', 'rm_purchase_returns_payment_type_foreign')
                    ->references('id')->on('payment_types')
                    ->cascadeOnUpdate()
                    ->nullOnDelete();
            }

            // return_by / approved_by / created_by / updated_by -> users(id)
            if (Schema::hasTable('users')) {
                $table->foreign('return_by', 'rm_purchase_returns_return_by_foreign')
                    ->references('id')->on('users')
                    ->cascadeOnUpdate()
                    ->nullOnDelete();

                $table->foreign('approved_by', 'rm_purchase_returns_approved_by_foreign')
                    ->references('id')->on('users')
                    ->cascadeOnUpdate()
                    ->nullOnDelete();

                $table->foreign('created_by', 'rm_purchase_returns_created_by_foreign')
                    ->references('id')->on('users')
                    ->cascadeOnUpdate()
                    ->nullOnDelete();

                $table->foreign('updated_by', 'rm_purchase_returns_updated_by_foreign')
                    ->references('id')->on('users')
                    ->cascadeOnUpdate()
                    ->nullOnDelete();
            }
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_purchase_returns');
    }
};
