<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_purchase_details', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->id();

            // From your dump (all nullable per structure)
            $table->unsignedBigInteger('purchase_id')->nullable()->index('rm_purchase_details_purchase_id_index');
            $table->unsignedBigInteger('product_id')->nullable()->index('rm_purchase_details_product_id_index');
            $table->unsignedBigInteger('bag_type_id')->nullable()->index('rm_purchase_details_bag_type_id_index');

            $table->decimal('price', 10, 2)->nullable();
            $table->decimal('vat', 10, 2)->default(0.00); // NOT NULL default 0.00

            // These 3 are varchar(191) in your dump
            $table->string('kg', 191)->nullable();
            $table->string('mon', 191)->nullable();
            $table->string('bag', 191)->nullable();

            $table->decimal('returned_kg',  8, 2)->default(0.00);
            $table->decimal('returned_bag', 8, 2)->default(0.00);
            $table->decimal('returned_mon', 8,  2)->default(0.00);

            $table->string('returnable_bag', 191)->nullable();
            $table->string('total_price', 191)->nullable();
            $table->string('remarks', 191)->nullable();

            $table->timestamps();

            $table->decimal('damage_kg',  8, 2)->default(0.00);
            $table->decimal('damage_bag', 8, 2)->default(0.00);
            $table->decimal('damage_mon', 8, 2)->default(0.00);
        });

        // Add foreign keys if parent tables exist (prevents errno:150)
        Schema::table('rm_purchase_details', function (Blueprint $table) {
            // purchase_id -> rm_purchases(id)
            if (Schema::hasTable('rm_purchases')) {
                $table->foreign('purchase_id', 'rm_purchase_details_purchase_id_foreign')
                      ->references('id')->on('rm_purchases')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();
            }

            // product_id -> rm_products(id) OR products(id)
            if (Schema::hasTable('rm_products')) {
                $table->foreign('product_id', 'rm_purchase_details_product_id_foreign')
                      ->references('id')->on('rm_products')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();
            } elseif (Schema::hasTable('products')) {
                $table->foreign('product_id', 'rm_purchase_details_product_id_foreign')
                      ->references('id')->on('products')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();
            }

            // bag_type_id -> bag_types(id) OR rm_bag_types(id)
            if (Schema::hasTable('bag_types')) {
                $table->foreign('bag_type_id', 'rm_purchase_details_bag_type_id_foreign')
                      ->references('id')->on('bag_types')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();
            } elseif (Schema::hasTable('rm_bag_types')) {
                $table->foreign('bag_type_id', 'rm_purchase_details_bag_type_id_foreign')
                      ->references('id')->on('rm_bag_types')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();
            }
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_purchase_details');
    }
};
