<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_purchases', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->id();

            // আপনার ডাম্প অনুযায়ী কলামগুলো
            $table->unsignedBigInteger('company_id')->nullable()->index('rm_purchases_company_id_index');
            $table->string('invoice_no', 191)->nullable();
            $table->unsignedBigInteger('supplier_id')->nullable()->index('rm_purchases_supplier_id_index');
            $table->unsignedBigInteger('employee_id')->nullable()->index('rm_purchases_employee_id_index');
            $table->string('date', 191)->nullable();

            $table->unsignedBigInteger('bag_warehouse_id')->nullable();
            $table->tinyInteger('bag_price_type')->nullable()->comment('1=>exclusive,2=inclusive');
            $table->decimal('bag_price', 10, 2)->nullable();

            $table->string('payment_type', 191)->nullable();

            $table->decimal('subtotal',       16, 2)->nullable();
            $table->decimal('discount',       16, 2)->nullable();
            $table->decimal('vat',            16, 2)->nullable();
            $table->decimal('payable_amount', 16, 2)->nullable();
            $table->decimal('paid_amount',    16, 2)->nullable();
            $table->decimal('due_amount',     16, 2)->nullable();

            $table->tinyInteger('type')->nullable()->comment('1=>raw,2=finish');

            $table->string('reference', 191)->nullable();
            $table->string('attachment', 191)->nullable();

            $table->unsignedBigInteger('created_by')->nullable()->index('rm_purchases_created_by_index');
            $table->unsignedBigInteger('updated_by')->nullable()->index('rm_purchases_updated_by_index');

            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();

            $table->unsignedBigInteger('warehouse_id')->nullable();

            // Extra helpful indexes
            $table->index('invoice_no', 'rm_purchases_invoice_no_index');
            $table->index('warehouse_id', 'rm_purchases_warehouse_id_index');
            $table->index('bag_warehouse_id', 'rm_purchases_bag_warehouse_id_index');
        });

        // FKs parent টেবিল থাকলে তবেই অ্যাড হবে (safe)
        Schema::table('rm_purchases', function (Blueprint $table) {
            // companies
            if (Schema::hasTable('companies')) {
                $table->foreign('company_id', 'rm_purchases_company_id_foreign')
                      ->references('id')->on('companies')
                      ->cascadeOnUpdate()->nullOnDelete();
            }

            // suppliers
            if (Schema::hasTable('suppliers')) {
                $table->foreign('supplier_id', 'rm_purchases_supplier_id_foreign')
                      ->references('id')->on('suppliers')
                      ->cascadeOnUpdate()->nullOnDelete();
            }

            // employees / rm_employees (যেটা আছে সেটাই ধরবে)
            if (Schema::hasTable('rm_employees')) {
                $table->foreign('employee_id', 'rm_purchases_employee_id_foreign')
                      ->references('id')->on('rm_employees')
                      ->cascadeOnUpdate()->nullOnDelete();
            } elseif (Schema::hasTable('employees')) {
                $table->foreign('employee_id', 'rm_purchases_employee_id_foreign')
                      ->references('id')->on('employees')
                      ->cascadeOnUpdate()->nullOnDelete();
            }

            // warehouses
            if (Schema::hasTable('warehouses')) {
                $table->foreign('warehouse_id', 'rm_purchases_warehouse_id_foreign')
                      ->references('id')->on('warehouses')
                      ->cascadeOnUpdate()->nullOnDelete();

                $table->foreign('bag_warehouse_id', 'rm_purchases_bag_warehouse_id_foreign')
                      ->references('id')->on('warehouses')
                      ->cascadeOnUpdate()->nullOnDelete();
            }

            // users (created_by / updated_by)
            if (Schema::hasTable('users')) {
                $table->foreign('created_by', 'rm_purchases_created_by_foreign')
                      ->references('id')->on('users')
                      ->cascadeOnUpdate()->nullOnDelete();

                $table->foreign('updated_by', 'rm_purchases_updated_by_foreign')
                      ->references('id')->on('users')
                      ->cascadeOnUpdate()->nullOnDelete();
            }
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_purchases');
    }
};

