<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        // 1) Create table (no FK yet)
        Schema::create('rm_product_adjustment_details', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->id(); // BIGINT UNSIGNED AI

            // From your dump
            $table->unsignedBigInteger('product_adjustment_id');   // NOT NULL
            $table->unsignedBigInteger('product_id')->nullable();  // NULL
            $table->unsignedBigInteger('warehouse_id')->nullable();// NULL

            $table->decimal('quantity', 8, 2)->nullable()->default(0.00);
            $table->string('adjustment_type', 191)->nullable();
            $table->string('remarks', 191)->nullable();
            $table->decimal('price',    16, 2)->nullable();
            $table->decimal('subtotal', 16, 2)->nullable();

            // timestamps nullable (per dump)
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();

            // helpful indexes (optional, keeps planner happy)
            $table->index('product_adjustment_id', 'rmpad_product_adjustment_id_index');
            $table->index('product_id',            'rmpad_product_id_index');
            $table->index('warehouse_id',          'rmpad_warehouse_id_index');
        });

        // 2) Add foreign keys only if parents exist (prevents errno:150)
        Schema::table('rm_product_adjustment_details', function (Blueprint $table) {
            if (Schema::hasTable('rm_product_adjustments')) {
                $table->foreign('product_adjustment_id', 'rmpad_product_adjustment_id_foreign')
                      ->references('id')->on('rm_product_adjustments')
                      ->cascadeOnUpdate()
                      ->cascadeOnDelete(); // delete details with header
            }

            // product_id -> prefer rm_products; fall back to products if present
            if (Schema::hasTable('rm_products')) {
                $table->foreign('product_id', 'rmpad_product_id_foreign')
                      ->references('id')->on('rm_products')
                      ->cascadeOnUpdate()
                      ->nullOnDelete(); // nullable in dump
            } elseif (Schema::hasTable('products')) {
                $table->foreign('product_id', 'rmpad_product_id_foreign')
                      ->references('id')->on('products')
                      ->cascadeOnUpdate()
                      ->nullOnDelete();
            }

            if (Schema::hasTable('warehouses')) {
                $table->foreign('warehouse_id', 'rmpad_warehouse_id_foreign')
                      ->references('id')->on('warehouses')
                      ->cascadeOnUpdate()
                      ->nullOnDelete(); // nullable in dump
            }
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_product_adjustment_details');
    }
};

