<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_product_adjustments', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->id(); // BIGINT UNSIGNED AI

            $table->foreignId('warehouse_id')
                  ->nullable()
                  ->constrained('warehouses')
                  ->cascadeOnUpdate()
                  ->nullOnDelete();

            $table->string('invoice_no', 191)->nullable();
            $table->date('date')->nullable();

            $table->decimal('total_quantity', 8, 2)->nullable();
            $table->string('remarks', 191)->nullable();
            $table->tinyInteger('type')->nullable();

            $table->foreignId('created_by')
                  ->nullable()
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->nullOnDelete();

            $table->foreignId('updated_by')
                  ->nullable()
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->nullOnDelete();

            // timestamps nullable per dump
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_product_adjustments');
    }
};

