<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_party_types', function (Blueprint $table) {
            $table->id();                                // BIGINT UNSIGNED AI
            $table->string('name', 191);                 // NOT NULL

            $table->tinyInteger('is_due')->nullable()->default(0);
            $table->string('status', 191)->default('1'); // NOT NULL default '1'

            // nullable FKs to users (as your index list shows)
            $table->foreignId('created_by')
                  ->nullable()
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->nullOnDelete(); // rm_party_types_created_by_foreign

            $table->foreignId('updated_by')
                  ->nullable()
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->nullOnDelete(); // rm_party_types_updated_by_foreign

            // timestamps nullable (per dump)
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_party_types');
    }
};

