<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_order_return_details', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            // FKs (nullable per dump)
            $table->foreignId('order_return_id')
                  ->nullable()
                  ->constrained('rm_order_returns')   // rm_order_return_details_order_return_id_foreign
                  ->cascadeOnUpdate()
                  ->nullOnDelete();

            $table->foreignId('order_detail_id')
                  ->nullable()
                  ->constrained('rm_order_details')   // rm_order_return_details_order_detail_id_foreign
                  ->cascadeOnUpdate()
                  ->nullOnDelete();

            $table->foreignId('product_id')
                  ->nullable()
                  ->constrained('products')           // rm_order_return_details_product_id_foreign
                  ->cascadeOnUpdate()
                  ->nullOnDelete();

            // Numbers (nullable as in dump)
            $table->decimal('kg',           8, 2)->nullable();
            $table->decimal('bag',          8, 2)->nullable();
            $table->decimal('mon',          8, 2)->nullable();
            $table->decimal('price',        8, 2)->nullable();
            $table->decimal('total_amount', 8, 2)->nullable();

            $table->string('product_condition', 191)->nullable();

            // Timestamps (nullable like dump)
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_order_return_details');
    }
};

