<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_order_returns', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            $table->string('invoice_no', 191)->nullable();

            // Only FK shown in your index list
            $table->foreignId('order_id')
                  ->nullable()
                  ->constrained('rm_orders')
                  ->cascadeOnUpdate()
                  ->nullOnDelete(); // rm_order_returns_order_id_foreign

            // Other columns (no FKs in your dump)
            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('customer_id')->nullable();
            $table->unsignedBigInteger('warehouse_id')->nullable();

            $table->date('return_date')->nullable();
            $table->string('return_reason', 191)->nullable();
            $table->string('note', 191)->nullable();

            // In dump: is_approved is varchar with default '0'
            $table->string('is_approved', 191)->default('0');

            $table->decimal('total_return_bag',    15, 2)->nullable();
            $table->decimal('total_return_kg',     15, 2)->nullable();
            $table->decimal('total_return_mon',    15, 2)->nullable();
            $table->decimal('total_return_amount', 15, 2)->nullable();

            $table->decimal('paid_amount', 8, 2)->default(0.00);
            $table->decimal('due_amount',  8, 2)->default(0.00);

            $table->unsignedBigInteger('payment_type')->nullable();
            $table->unsignedBigInteger('return_by')->nullable();
            $table->unsignedBigInteger('approved_by')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();

            $table->decimal('order_return_cost', 16, 2)->nullable();

            // (Optional) indexes that mirror phpMyAdmin “Index” markers if you want:
            $table->index('order_id', 'rm_order_returns_order_id_index');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_order_returns');
    }
};

