<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    private function pickBagTypesTable(): ?string
    {
        foreach (['bag_types', 'rm_bag_types'] as $name) {
            if (Schema::hasTable($name)) return $name;
        }
        return null;
    }

    public function up(): void
    {
        if (!Schema::hasTable('rm_order_details')) return;

        $bagTypes = $this->pickBagTypesTable();
        if (!Schema::hasTable('rm_orders')) {
            throw new RuntimeException("Parent table 'rm_orders' not found.");
        }
        if (!$bagTypes) {
            throw new RuntimeException("No bag types table found. Expected 'bag_types' or 'rm_bag_types'.");
        }

        Schema::table('rm_order_details', function (Blueprint $table) use ($bagTypes) {
            // নামগুলো আপনার ডাম্পের মতই রাখছি:
            // rm_order_details_order_id_foreign
            // rm_order_details_bag_type_id_foreign

            if (Schema::hasColumn('rm_order_details', 'order_id')) {
                $table->foreign('order_id', 'rm_order_details_order_id_foreign')
                      ->references('id')->on('rm_orders')
                      ->cascadeOnUpdate()
                      ->nullOnDelete(); // column nullable, so SET NULL on delete
            }

            if (Schema::hasColumn('rm_order_details', 'bag_type_id')) {
                $table->foreign('bag_type_id', 'rm_order_details_bag_type_id_foreign')
                      ->references('id')->on($bagTypes)
                      ->cascadeOnUpdate()
                      ->nullOnDelete(); // column nullable, so SET NULL on delete
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('rm_order_details')) return;

        Schema::table('rm_order_details', function (Blueprint $table) {
            // silently drop if exist
            try { $table->dropForeign('rm_order_details_order_id_foreign'); } catch (\Throwable $e) {}
            try { $table->dropForeign('rm_order_details_bag_type_id_foreign'); } catch (\Throwable $e) {}
        });
    }
};
