<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_order_details', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            // Nullable per dump
            $table->unsignedBigInteger('order_id')->nullable();
            $table->unsignedBigInteger('product_id')->nullable();
            $table->unsignedBigInteger('bag_type_id')->nullable();

            // Numbers (defaults exactly like dump)
            $table->decimal('price',       10, 2)->default(0.00);
            $table->decimal('total_price', 10, 2)->default(0.00);
            $table->decimal('kg',          10, 2)->default(0.00);
            $table->decimal('bag',         10, 2)->default(0.00);
            $table->decimal('mon',         10, 2)->default(0.00);

            $table->decimal('returned_kg',  8, 2)->default(0.00);
            $table->decimal('returned_bag', 8, 2)->default(0.00);
            $table->decimal('returned_mon', 8, 2)->default(0.00);

            $table->decimal('delivery_kg',  20, 2)->default(0.00);
            $table->decimal('delivery_bag', 20, 2)->default(0.00);
            $table->decimal('delivery_mon', 20, 2)->default(0.00);

            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();

            $table->string('remarks', 191)->nullable();

            // (ঐচ্ছিক) ইনডেক্স
            $table->index('order_id', 'rm_order_details_order_id_index');
            $table->index('bag_type_id', 'rm_order_details_bag_type_id_index');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_order_details');
    }
};

