<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_order_delivery_details', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            // NOT NULL (per dump)
            $table->unsignedBigInteger('delivery_id');
            $table->unsignedBigInteger('product_id');

            // Nullable (per dump)
            $table->unsignedBigInteger('bag_type_id')->nullable();
            $table->unsignedBigInteger('order_detail_id')->nullable();
            $table->unsignedBigInteger('warehouse_id')->nullable();

            // Numbers (defaults per dump)
            $table->decimal('bag',         20, 2)->default(0.00);
            $table->decimal('kg',          20, 2)->default(0.00);
            $table->decimal('mon',         20, 2)->default(0.00);
            $table->decimal('price',       20, 2)->default(0.00);
            $table->decimal('total_price', 20, 2)->default(0.00);

            // Timestamps nullable
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_order_delivery_details');
    }
};

