<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_mills', function (Blueprint $table) {
            $table->id();

            $table->string('name', 191);
            $table->string('status', 191)->default('1'); // চাইলে tinyInteger রাখলেও হবে

            $table->foreignId('created_by')
                  ->nullable()
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->nullOnDelete();

            $table->foreignId('updated_by')
                  ->nullable()
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->nullOnDelete();

            $table->timestamps();   // created_at & updated_at (nullable নয়)
            $table->softDeletes();  // <-- এই লাইনটাই মূল সমাধান (deleted_at)
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_mills');
    }
};

