<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_labour_cost_details', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            // Columns per dump
            $table->unsignedBigInteger('rm_labour_cost_id')->nullable(); // no FK in your dump
            $table->foreignId('product_id')
                  ->nullable()
                  ->constrained('products')
                  ->cascadeOnUpdate()
                  ->nullOnDelete(); // rm_labour_cost_details_product_id_foreign

            $table->decimal('bag',              8, 2)->default(0.00);
            $table->decimal('unit_labour_cost', 8, 2)->default(0.00);
            $table->decimal('total_labour_cost',8, 2)->default(0.00);

            // timestamps as nullable (to match dump)
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_labour_cost_details');
    }
};
