<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_labour_costs', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            // FK shown in dump
            $table->foreignId('company_id')
                  ->nullable()
                  ->constrained('companies')
                  ->cascadeOnUpdate()
                  ->nullOnDelete(); // rm_labour_costs_company_id_foreign

            // Other columns (no FKs in your dump)
            $table->string('invoice_no', 191)->nullable();
            $table->string('source', 191)->nullable();
            $table->unsignedBigInteger('source_id')->nullable();
            $table->string('source_invoice_no', 191)->nullable();
            $table->date('date')->nullable();

            $table->tinyInteger('source_type')->nullable()->comment('1=>raw,2=>finish');

            $table->decimal('total_amount', 8, 2)->default(0.00);
            $table->decimal('paid_amount',  8, 2)->default(0.00);
            $table->decimal('due_amount',   8, 2)->default(0.00);

            $table->unsignedBigInteger('payment_type')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();

            // Timestamps as nullable (to match dump)
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_labour_costs');
    }
};

