<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_invoice_nos', function (Blueprint $table) {
            $table->id();                          // BIGINT UNSIGNED AI
            $table->string('type', 191);           // NOT NULL
            $table->string('year', 191);           // NOT NULL
            $table->unsignedInteger('next_id')->default(1); // INT(10) UNSIGNED, default 1
            $table->unsignedBigInteger('company_id')->nullable(); // nullable, no FK per dump

            // Timestamps (nullable as in dump)
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();

            // Optional helpful index if you query by company
            // $table->index('company_id', 'rm_invoice_nos_company_id_index');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_invoice_nos');
    }
};

