<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_employee_designations', function (Blueprint $table) {
            $table->id();                                // BIGINT UNSIGNED AI

            $table->string('name', 191);                 // NOT NULL
            $table->string('status', 191)->default('1'); // NOT NULL default '1'

            // FKs per dump
            $table->foreignId('created_by')
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();                  // rm_employee_designations_created_by_foreign

            $table->foreignId('updated_by')
                  ->nullable()
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->nullOnDelete();                      // rm_employee_designations_updated_by_foreign

            // Timestamps (nullable)
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_employee_designations');
    }
};
