<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('rm_employees')) {
            Schema::create('rm_employees', function (Blueprint $table) {
                $table->id(); // BIGINT UNSIGNED AI

                // FK columns now as plain columns (FKs will be added later)
                $table->unsignedBigInteger('designation_id'); // NOT NULL (dump)
                $table->unsignedBigInteger('department_id');  // NOT NULL (dump)

                // Data columns (exact per dump)
                $table->string('name', 191);
                $table->integer('phone')->nullable(); // INT(11)
                $table->string('address', 191)->nullable();
                $table->date('date_of_birth')->nullable();
                $table->string('nid', 191)->nullable();
                $table->string('gender', 191)->nullable();
                $table->string('nationality', 191)->nullable();
                $table->string('religion', 191)->nullable();
                $table->text('image')->nullable();

                // created_by NOT NULL; updated_by NULL
                $table->unsignedBigInteger('created_by');
                $table->unsignedBigInteger('updated_by')->nullable();

                $table->timestamp('created_at')->nullable();
                $table->timestamp('updated_at')->nullable();

                // helpful indexes (optional)
                $table->index('designation_id', 'rm_employees_designation_id_index');
                $table->index('department_id',  'rm_employees_department_id_index');
                $table->index('created_by',     'rm_employees_created_by_index');
                $table->index('updated_by',     'rm_employees_updated_by_index');
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_employees');
    }
};

