<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('rm_delivery_details')) {
            Schema::create('rm_delivery_details', function (Blueprint $table) {
                $table->id(); // BIGINT UNSIGNED AI

                // FK columns (FKs will be added in a follow-up migration)
                $table->unsignedBigInteger('delivery_id'); // NOT NULL
                $table->unsignedBigInteger('product_id');  // NOT NULL
                $table->unsignedBigInteger('bag_type_id')->nullable();
                $table->unsignedBigInteger('sale_detail_id')->nullable();

                // Data columns (per dump)
                $table->decimal('bag',        20, 2)->default(0.00);
                $table->decimal('kg',         20, 2)->default(0.00);
                $table->decimal('mon',        20, 2)->default(0.00);
                $table->decimal('price',      20, 2)->default(0.00);
                $table->decimal('total_price',20, 2)->default(0.00);

                $table->timestamp('created_at')->nullable();
                $table->timestamp('updated_at')->nullable();
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_delivery_details');
    }
};
