<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_customer_due_collections', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            // Nullable FK -> rm_customers(id)
            $table->foreignId('customer_id')
                  ->nullable()
                  ->constrained('rm_customers')
                  ->cascadeOnUpdate()
                  ->nullOnDelete(); // rm_customer_due_collections_customer_id_foreign

            $table->tinyInteger('payment_type')->nullable();
            $table->string('invoice_no', 191)->nullable();
            $table->date('date')->nullable();

            $table->double('cus_current_balance')->nullable();
            $table->double('cus_paid_amount')->nullable();
            $table->double('discount')->nullable();

            $table->tinyInteger('status')->default(1); // NOT NULL default 1
            $table->text('remark')->nullable();

            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();

            // timestamps as nullable (to match your dump)
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_customer_due_collections');
    }
};

