<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_customers', function (Blueprint $table) {
            $table->id();                                     // BIGINT UNSIGNED AI

            $table->string('name', 191);                      // NOT NULL
            $table->string('customerId', 191)->nullable();    // nullable string (camelCase per dump)
            $table->unsignedBigInteger('account_id')->nullable();
            $table->string('company_name', 191)->nullable();

            $table->string('personal_phone', 191);            // NOT NULL
            $table->integer('bussiness_phone')->nullable();   // INT(11) (signed)

            $table->string('email', 191)->nullable();
            $table->string('address', 191)->nullable();

            $table->decimal('opening_balance', 10, 2)->nullable();
            $table->decimal('current_balance', 16, 2)->nullable()->default(0.00);
            $table->decimal('due_limit', 10, 2)->nullable();
            $table->string('remarks', 191)->nullable();

            $table->tinyInteger('customer_type')->nullable()->comment('0=baki,1=nagad');
            $table->string('executive_name', 191)->nullable();

            $table->unsignedBigInteger('area_id')->nullable();
            $table->unsignedBigInteger('employee_id')->nullable();

            $table->tinyInteger('discount_type')->nullable()->comment('1 => %, 2 => flat');
            $table->decimal('discount', 10, 2)->nullable();
            $table->decimal('assume_rate', 10, 2)->nullable();

            $table->text('image')->nullable();
            $table->tinyInteger('status')->default(0);        // NOT NULL default 0

            // FKs shown in dump
            $table->foreignId('created_by')
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();                       // rm_customers_created_by_foreign

            $table->foreignId('updated_by')
                  ->nullable()
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->nullOnDelete();                           // rm_customers_updated_by_foreign

            $table->timestamps();                             // created_at / updated_at (nullable)
            $table->unsignedBigInteger('party_type_id')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_customers');
    }
};
