<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_categories', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            $table->string('name', 191);                 // NOT NULL
            $table->string('code', 191)->nullable();     // NULL
            $table->string('status', 191)->default('0'); // NOT NULL default '0'

            // FKs exactly like your dump
            $table->foreignId('created_by')
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete(); // rm_categories_created_by_foreign

            $table->foreignId('updated_by')
                  ->nullable()
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->nullOnDelete();     // rm_categories_updated_by_foreign

            // created_at / updated_at (nullable)
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_categories');
    }
};

