<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_bag_types', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            $table->string('name', 191);                 // NOT NULL
            $table->decimal('bag_size', 8, 2)->nullable();
            $table->string('opening_quantity', 191)->nullable();
            $table->string('status', 191)->default('0'); // NOT NULL default '0'

            // FKs exactly as in your dump
            $table->foreignId('created_by')
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete(); // rm_bag_types_created_by_foreign

            $table->foreignId('updated_by')
                  ->nullable()
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->nullOnDelete();     // rm_bag_types_updated_by_foreign

            // Timestamps (nullable in your dump)
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_bag_types');
    }
};

