<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('rm_bag_stocks')) {
            Schema::create('rm_bag_stocks', function (Blueprint $table) {
                $table->id(); // BIGINT UNSIGNED AI

                // FK columns (FKs will be added later)
                $table->unsignedBigInteger('bag_type_id')->nullable();
                $table->unsignedBigInteger('company_id')->nullable();
                $table->unsignedBigInteger('supplier_id')->nullable();
                $table->unsignedBigInteger('employee_id')->nullable();

                // quantities: NOT NULL defaults
                $table->decimal('opening_quantity',         10, 2)->default(0.00);
                $table->decimal('purchased_quantity',       10, 2)->default(0.00);
                $table->decimal('sold_quantity',            10, 2)->default(0.00);
                $table->decimal('order_sold_quantity',      10, 2)->default(0.00);
                $table->decimal('return_quantity',          10, 2)->default(0.00);
                $table->decimal('purchase_return_quantity', 10, 2)->default(0.00);
                $table->decimal('un_empty_quantity',        10, 2)->default(0.00);
                $table->decimal('empty_quantity',           10, 2)->default(0.00);
                $table->decimal('adjustment_in',            10, 2)->default(0.00);
                $table->decimal('adjustment_out',           10, 2)->default(0.00);
                $table->decimal('transfer_in',              10, 2)->default(0.00);
                $table->decimal('transfer_out',             10, 2)->default(0.00);
                $table->decimal('available_quantity',       10, 2)->default(0.00);

                $table->string('variant', 191)->nullable();

                // created_by NOT NULL, updated_by NULL
                $table->unsignedBigInteger('created_by');
                $table->unsignedBigInteger('updated_by')->nullable();

                $table->timestamps();
                $table->unsignedBigInteger('warehouse_id')->nullable(); // no FK in dump

                // helpful indexes (safe)
                $table->index('bag_type_id', 'rm_bag_stocks_bag_type_id_index');
                $table->index('company_id',  'rm_bag_stocks_company_id_index');
                $table->index('supplier_id', 'rm_bag_stocks_supplier_id_index');
                $table->index('employee_id', 'rm_bag_stocks_employee_id_index');
                $table->index('created_by',  'rm_bag_stocks_created_by_index');
                $table->index('updated_by',  'rm_bag_stocks_updated_by_index');
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('rm_bag_stocks');
    }
};
