<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rmstock_transfer_details', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            $table->unsignedBigInteger('stock_transfer_id'); // NOT NULL
            $table->unsignedBigInteger('product_id');        // NOT NULL

            $table->double('price')->nullable();
            $table->double('transfer_kg')->nullable();
            $table->double('transfer_mon')->nullable();
            $table->double('transfer_bag')->nullable();
            $table->double('transfer_amount')->nullable();

            $table->double('approved_kg')->nullable();
            $table->double('approved_mon')->nullable();
            $table->double('approved_bag')->nullable();
            $table->double('approved_amount')->nullable();

            $table->double('received_kg')->nullable();
            $table->double('received_mon')->nullable();
            $table->double('received_bag')->nullable();
            $table->double('received_amount')->nullable();

            $table->string('remarks', 191)->nullable();
            $table->tinyInteger('status')->default(1); // NOT NULL default 1

            $table->timestamps(); // created_at, updated_at (nullable)
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rmstock_transfer_details');
    }
};

