<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rmstock_transfers', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            $table->unsignedBigInteger('company_id')->nullable();
            $table->string('invoice_no', 191)->nullable();
            $table->unsignedBigInteger('from_warehouse_id')->nullable();
            $table->unsignedBigInteger('to_warehouse_id')->nullable();

            $table->double('total_kg')->nullable();
            $table->double('total_bag')->nullable();
            $table->double('total_mon')->nullable();
            $table->double('total_amount')->nullable();
            $table->double('transfer_cost')->default(0); // NOT NULL default 0

            $table->string('type', 191)->nullable();
            $table->tinyInteger('is_approved')->default(0); // NOT NULL default 0
            $table->text('note')->nullable();

            $table->date('date')->nullable();
            $table->string('current_status', 191)->nullable()->default('Pending');
            $table->date('approve_date')->nullable();
            $table->date('receive_date')->nullable();
            $table->date('cancel_date')->nullable();

            $table->unsignedBigInteger('approved_by')->nullable();
            $table->unsignedBigInteger('received_by')->nullable();
            $table->unsignedBigInteger('cancelled_by')->nullable();

            $table->unsignedBigInteger('created_by');           // NOT NULL in dump
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->timestamps(); // created_at, updated_at (nullable as in dump)
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rmstock_transfers');
    }
};

