<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rmreports', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            $table->unsignedBigInteger('product_id');   // NOT NULL
            $table->unsignedBigInteger('company_id');   // NOT NULL
            $table->unsignedBigInteger('factory_id')->nullable();
            $table->string('date', 191);                // NOT NULL (dump shows varchar)
            $table->unsignedBigInteger('unit_id')->nullable();

            $table->decimal('stock', 8, 2)->default(0.00); // NOT NULL default 0.00
            $table->decimal('avg_rate', 8, 2);             // NOT NULL, no default

            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();

            $table->decimal('stock_in', 8, 2)->nullable();
            $table->decimal('stock_out', 8, 2)->nullable();
            $table->unsignedBigInteger('branch_id')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rmreports');
    }
};
