<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('rmbag_returns')) {
            Schema::create('rmbag_returns', function (Blueprint $table) {
                $table->id();

                // FK columns (nullable per dump) — FK add হবে পরে
                $table->unsignedBigInteger('customer_id')->nullable();
                $table->unsignedBigInteger('supplier_id')->nullable();
                $table->unsignedBigInteger('warehouse_id')->nullable();
                $table->unsignedBigInteger('created_by')->nullable();
                $table->unsignedBigInteger('updated_by')->nullable();

                // Data columns (exact per dump)
                $table->string('quantity', 191);              // NOT NULL
                $table->string('status', 191)->default('1');  // NOT NULL default '1'
                $table->timestamp('created_at')->nullable();
                $table->timestamp('updated_at')->nullable();
                $table->string('reference', 191)->nullable();
                $table->date('date')->nullable();
                $table->string('invoice_no', 191)->nullable();
                $table->string('description', 191)->nullable();

                // Helpful indexes (safe)
                $table->index('customer_id',  'rmbag_returns_customer_id_index');
                $table->index('supplier_id',  'rmbag_returns_supplier_id_index');
                $table->index('warehouse_id', 'rmbag_returns_warehouse_id_index');
                $table->index('created_by',   'rmbag_returns_created_by_index');
                $table->index('updated_by',   'rmbag_returns_updated_by_index');
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('rmbag_returns');
    }
};
