<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('requsition_stocks', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            // Nullable FK -> products(id)
            $table->foreignId('product_id')
                  ->nullable()
                  ->constrained('products')
                  ->cascadeOnUpdate()
                  ->nullOnDelete(); // column is NULL-able in your dump

            // Other columns (exact types/defaults)
            $table->timestamp('date')->nullable();
            $table->string('type', 191)->nullable();
            $table->integer('source_id')->nullable(); // int(11) signed
            $table->string('source_number', 191)->nullable();

            $table->decimal('debit_qty',  15, 3)->default(0.000);
            $table->decimal('credit_qty', 15, 3)->default(0.000);
            $table->decimal('debit_rate', 15, 3)->default(0.000);
            $table->decimal('credit_rate',15, 3)->default(0.000);

            // FKs to users
            $table->foreignId('created_by')
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete(); // NOT NULL in dump

            $table->foreignId('updated_by')
                  ->nullable()
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->nullOnDelete(); // NULL-able in dump

            // Plain nullable refs (no FKs shown in dump)
            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('factory_id')->nullable();
            $table->unsignedBigInteger('branch_id')->nullable();

            $table->timestamps(); // created_at, updated_at (nullable)
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('requsition_stocks');
    }
};
