<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('raw_bag_purchases')) {
            Schema::create('raw_bag_purchases', function (Blueprint $table) {
                $table->id(); // BIGINT UNSIGNED AI

                $table->unsignedBigInteger('company_id')->nullable();
                $table->unsignedBigInteger('warehouse_id')->nullable();

                $table->string('invoice_no', 191)->nullable();
                $table->unsignedBigInteger('supplier_id')->nullable();
                $table->unsignedBigInteger('employee_id')->nullable();

                $table->string('date', 191)->nullable();       // dump shows varchar
                $table->string('payment_type', 191)->nullable();

                $table->decimal('quantity',       10, 2)->nullable();
                $table->decimal('price',          10, 2)->nullable();
                $table->decimal('subtotal',       10, 2)->nullable();
                $table->decimal('discount',       10, 2)->nullable();
                $table->decimal('vat',            10, 2)->nullable();
                $table->decimal('payable_amount', 10, 2)->nullable();
                $table->decimal('paid_amount',    10, 2)->nullable();
                $table->decimal('due_amount',     10, 2)->nullable();

                $table->string('reference', 191)->nullable();
                $table->text('attachment')->nullable();

                $table->unsignedBigInteger('created_by')->nullable();
                $table->unsignedBigInteger('updated_by')->nullable();

                $table->timestamps();                    // nullable by MySQL
                $table->tinyInteger('with_bag')->default(0);

                // Helpful indexes (matches your dump’s constrained columns)
                $table->index('supplier_id', 'raw_bag_purchases_supplier_id_index');
                $table->index('employee_id', 'raw_bag_purchases_employee_id_index');
                $table->index('created_by',  'raw_bag_purchases_created_by_index');
                $table->index('updated_by',  'raw_bag_purchases_updated_by_index');
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('raw_bag_purchases');
    }
};
