<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('raw_bag_adjustments', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            $table->unsignedBigInteger('warehouse_id')->nullable();
            $table->string('invoice_no', 191)->nullable();
            $table->date('date')->nullable();
            $table->decimal('quantity', 8, 2)->nullable();
            $table->string('remarks', 191)->nullable();
            $table->string('adjustment_type', 191)->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();

            // timestamps nullable (dump অনুযায়ী)
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('raw_bag_adjustments');
    }
};
