<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('purchase_receive_details')) {
            Schema::create('purchase_receive_details', function (Blueprint $table) {
                $table->id(); // BIGINT UNSIGNED AI

                // FK columns (FK পরে add হবে)
                $table->unsignedBigInteger('company_id');
                $table->unsignedBigInteger('created_by');
                $table->unsignedBigInteger('updated_by');
                $table->unsignedBigInteger('purchase_receive_id');
                $table->unsignedBigInteger('purchase_details_id');
                $table->unsignedBigInteger('item_id');
                $table->unsignedBigInteger('supplier_id');

                $table->decimal('quantity', 20, 2)->default(0.00);
                $table->decimal('rate',     20, 2)->default(0.00);
                $table->text('remarks')->nullable();

                $table->timestamps(); // created_at, updated_at (nullable)
                $table->integer('remaining_quantity')->nullable()->default(0);
                $table->text('image')->nullable();

                // Helpful indexes (safe; FK add করলে না থাকলে তাও index বানায়)
                $table->index('company_id',           'prd_company_id_index');
                $table->index('created_by',           'prd_created_by_index');
                $table->index('updated_by',           'prd_updated_by_index');
                $table->index('purchase_receive_id',  'prd_purchase_receive_id_index');
                $table->index('purchase_details_id',  'prd_purchase_details_id_index');
                $table->index('item_id',              'prd_item_id_index');
                $table->index('supplier_id',          'prd_supplier_id_index');
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('purchase_receive_details');
    }
};
