<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('purchase_receives', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            // FKs (NOT NULL in dump)
            $table->foreignId('company_id')
                  ->constrained('companies')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();

            // Nullable ref without FK in dump
            $table->unsignedBigInteger('warehouse_id')->nullable();

            $table->foreignId('created_by')
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();

            $table->foreignId('updated_by')
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();

            $table->foreignId('purchase_id')
                  ->constrained('purchases')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();

            // Other columns
            $table->string('form_number', 191)->nullable();
            $table->tinyInteger('is_approved')->default(0);
            $table->date('purchase_receive_date'); // NOT NULL
            $table->string('purchase_receive_reference', 191)->nullable();
            $table->string('purchase_challan_number', 191)->nullable();
            $table->string('challan_image', 191)->nullable()->default('default.png');
            $table->decimal('quantity', 20, 2)->default(0.00);

            $table->timestamps(); // created_at, updated_at (nullable by MySQL)
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('purchase_receives');
    }
};
