<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('purchase_details')) {
            Schema::create('purchase_details', function (Blueprint $table) {
                $table->id();

                // FK columns (FKs will be added later)
                $table->unsignedBigInteger('company_id');
                $table->unsignedBigInteger('created_by');
                $table->unsignedBigInteger('updated_by');
                $table->unsignedBigInteger('purchase_id');
                $table->unsignedBigInteger('item_id');

                $table->double('quantity')->default(0);
                $table->double('received_quantity')->default(0);
                $table->timestamps();

                // helpful indexes (match your dump’s intent)
                $table->index('company_id',  'purchase_details_company_id_index');
                $table->index('created_by',  'purchase_details_created_by_index');
                $table->index('updated_by',  'purchase_details_updated_by_index');
                $table->index('purchase_id', 'purchase_details_purchase_id_index');
                $table->index('item_id',     'purchase_details_item_id_index');
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('purchase_details');
    }
};


