<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('purchases', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            $table->string('invoice_no', 191)->nullable();

            // Nullable refs (no FKs in your dump)
            $table->unsignedBigInteger('employee_id')->nullable();
            $table->unsignedBigInteger('warehouse_id')->nullable();

            // FKs present in your dump
            $table->foreignId('company_id')
                  ->constrained('companies')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete(); // NOT NULL

            $table->foreignId('created_by')
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete(); // NOT NULL

            $table->foreignId('updated_by')
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete(); // NOT NULL

            $table->date('purchase_date');                // NOT NULL
            $table->string('purchase_reference', 191)->nullable();
            $table->tinyInteger('is_approved')->default(0); // NOT NULL default 0
            $table->string('form_number', 191)->nullable();
            $table->decimal('total', 20, 2)->default(0.00); // NOT NULL

            $table->timestamps(); // created_at, updated_at (nullable by MySQL)
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('purchases');
    }
};

