<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('product_stock_transections', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            $table->string('invoice_no', 191)->nullable();

            // FKs (NOT NULL as per dump)
            $table->foreignId('product_id')
                  ->constrained('products')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();

            $table->foreignId('company_id')
                  ->constrained('companies')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();

            // Nullable references (dump didn’t show FKs, so leave as plain columns)
            $table->unsignedBigInteger('factory_id')->nullable();
            $table->unsignedBigInteger('warehouse_id')->nullable();

            // Polymorphic-like source (no FK; matches dump)
            $table->string('source_type', 191);
            $table->integer('source_id'); // int(11) NOT NULL (signed, as in dump)

            // Note: dump shows date as varchar(191)
            $table->string('date', 191);

            $table->decimal('quantity', 16, 2)->default(0.00);
            $table->decimal('price',    16, 2)->default(0.00);

            // amount: VIRTUAL GENERATED (quantity * price)
            $table->decimal('amount', 16, 2)->virtualAs('(`quantity` * `price`)');

            $table->enum('stock_type', ['In', 'Out']);

            // FKs: created_by (NOT NULL), updated_by (NULL)
            $table->foreignId('created_by')
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();

            $table->foreignId('updated_by')
                  ->nullable()
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->nullOnDelete();

            $table->timestamps();

            // (Optional) Helpful indexes if you want fast filters on these:
            // $table->index(['factory_id']);
            // $table->index(['warehouse_id']);
            // $table->index(['source_type', 'source_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('product_stock_transections');
    }
};

