<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            // timestamps (nullable by MySQL)
            $table->timestamps();

            // nullable FKs/cols per dump
            $table->unsignedBigInteger('category_id')->nullable();
            $table->unsignedBigInteger('unit_id')->nullable();

            // fields (nullable/defaults exactly as in dump)
            $table->string('name', 191)->nullable();
            $table->string('product_type', 16)->nullable()->default('0');
            $table->string('product_code', 191)->nullable()->default('0');

            $table->decimal('purchase_price', 16, 2)->nullable()->default(0.00);
            $table->decimal('selling_price', 16, 2)->nullable()->default(0.00);
            $table->decimal('opening_quantity', 16, 2)->nullable()->default(0.00);
            $table->decimal('current_stock', 16, 2)->nullable()->default(0.00);

            $table->text('description')->nullable();

            // the two FKs your dump shows
            $table->foreignId('company_id')
                  ->nullable()
                  ->constrained('companies')
                  ->cascadeOnUpdate()
                  ->nullOnDelete(); // nullable in dump

            $table->foreignId('created_by')
                  ->nullable()
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->nullOnDelete(); // nullable in dump

            // present in dump but no FK there — keep as plain nullable column
            $table->unsignedBigInteger('updated_by')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};

