<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('permission_user', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            // FKs (NOT NULL) -> match your dump
            $table->foreignId('permission_id')
                  ->constrained('permissions')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete(); // change to ->cascadeOnDelete() if desired

            $table->foreignId('user_id')
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();

            $table->timestamps(); // created_at, updated_at (nullable)
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('permission_user');
    }
};

