<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('permission_features', function (Blueprint $table) {
            $table->id();                       // bigint unsigned auto-increment
            $table->string('name', 191);        // NOT NULL
            $table->tinyInteger('status')->default(1); // tinyint(4) NOT NULL default 1
            $table->timestamps();               // created_at, updated_at (nullable)

            // Unique index on name (matches: permission_features_name_unique)
            $table->unique('name', 'permission_features_name_unique');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('permission_features');
    }
};
