<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('permissions', function (Blueprint $table) {
            // Table options to match MySQL view
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->bigIncrements('id');

            $table->string('name', 191);
            $table->string('slug', 191)->unique(); // creates permissions_slug_unique
            $table->text('description')->nullable();

            // Foreign keys & indexes (names will be {table}_{column}_foreign)
            $table->foreignId('created_by')
                  ->constrained('users')
                  ->restrictOnDelete()
                  ->restrictOnUpdate();

            $table->foreignId('updated_by')
                  ->constrained('users')
                  ->restrictOnDelete()
                  ->restrictOnUpdate();

            $table->foreignId('parent_permission_id')
                  ->constrained('permissions')
                  ->restrictOnDelete()
                  ->restrictOnUpdate();

            // Timestamps as nullable (to match your table)
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();

            $table->tinyInteger('status')->default(1);   // tinyint(4) NOT NULL DEFAULT 1
            $table->integer('position')->nullable()->default(999);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('permissions');
    }
};
