<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('parent_permissions')) {
            Schema::create('parent_permissions', function (Blueprint $table) {
                $table->id();                       // BIGINT UNSIGNED AI
                $table->string('name', 191);        // NOT NULL
                $table->unsignedBigInteger('submodule_id'); // FK will be added later
                $table->timestamps();

                // helpful index (FK will also create one, but this is safe)
                $table->index('submodule_id', 'parent_permissions_submodule_id_index');
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('parent_permissions');
    }
};

