<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            // আপনার ডাম্প অনুযায়ী কলাম অর্ডার
            $table->unsignedBigInteger('source_id');          // NOT NULL (FK পরে চাইলে add করবেন)
            $table->string('type', 191);                      // NOT NULL
            $table->string('path', 191);                      // NOT NULL
            $table->string('slug', 191);                      // NOT NULL
            $table->string('description', 191)->nullable();

            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('department_id')->nullable();
            $table->unsignedBigInteger('designation_id')->nullable();
            $table->unsignedBigInteger('order_type_id')->nullable();
            $table->unsignedBigInteger('buyer_id')->nullable();

            $table->timestamps(); // created_at, updated_at (nullable)

            $table->unsignedBigInteger('employee_id')->nullable();

            // (ইচ্ছা হলে helpful indexes যোগ করতে পারেন; আপনার ডাম্পে আলাদা index দেখানো হয়নি, তাই রাখিনি)
            // উদাহরণ:
            // $table->index('source_id', 'notifications_source_id_index');
            // $table->index('slug', 'notifications_slug_index');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('notifications');
    }
};
